% This program estimates a level VAR with no intercept  in companion format by LS
%  adapted from
%OLSVARC.M by  Lutz Kilian University of Michigan April 1997
%Written Jonathan Hambur RBA 2016

function [A,SIGMA,U,V,X]=olsvarc_noint(y,p);


[t,q]=size(y);
X=[];

%Input matrix
for j=1 : p
    X=[X, y(p+1-j: t-j,:)];
end

% %Add constant
% X=[ones(t-p,1) X];
X=X';

% Create LHS matrix
Y=y(p+1:t,:);
Y=Y';   % tranpose y

%Store  
A=(Y*X')/(X*X'); % Beta coeffcient matrix 
U=Y-A*X; % Residual Matrix
SIGMA=U*U'/(t-p-p*q-1);	%Covariance matrix 
% V=A(:,1); %First column coefficients - intercepts
% A=A(:,2:q*p+1); %Rest of A matrix
V=zeros(q,1);




